#pragma once

#define ERR_LOADNOFUNC -1
#define ERR_LOADNOCODESEG -2
#define ERR_BADSTREAM -3
#define ERR_BADSIGNATURE -4

#include "list.h"
#include "stack.h"

//*******************************************************************************************************************
//Struktura pro uchovani informaci o knihovne z niz maji byt importovany funkce
//*******************************************************************************************************************
struct ExternFunction
{
	HMODULE		hDll;				//handle knihovny v ktere funkci najdeme
	FARPROC		address;			//adresa funkce
	char		type;				//navartova hodnota funkce

};
//*******************************************************************************************************************
//Struktura reprezentujici zdroje potrebne k provedeni skriptu
//*******************************************************************************************************************
struct ScriptDependencies
{
		unsigned char*						m_CodeSegment;			//ukazatel na kodovy segment
		unsigned int						m_CodeSegmentSize;		//velikost kodoveho segmentu
		unsigned int						m_NumConstants;			//pocet konstant v tabulce konstant
		CStack<StackItem>					m_ConstantTable;		//tabulka konstant
		CHashTable<char*,FUNCTION_HEADER*>*	m_FunctionList;			//tabulka funkci
		CHashTable<char*,ExternFunction*>*	m_Imports;				//tabulka importovanych funkci

		//konstruktor
		ScriptDependencies()
		{
			m_CodeSegment = NULL;
			m_CodeSegmentSize = 0;
		}
};

//*******************************************************************************************************************
//trida reprezentujici skript
//*******************************************************************************************************************
class CScript : public IScript
{
private:
	CList<FUNCTION_HEADER*>					m_FunctionTemplates;	//seznam se sablonami vsech funkci ve skriptu
	CList<CFunctionInstance*>				m_runningFunctions;		//seznam funkci ktere se prave provadeji
    CList<ExternFunction*>					m_importedFunctions;
	FILE*									m_File;				//soubor se skriptem

	IVirtualMachine*						m_VM;				//virtualni stroj

	DWORD									m_dwRef;

	ScriptDependencies						m_ScriptDependencies;

	CFunctionInstance*						m_CurrFunction;
private:
	//pomocne fce pro cteni dat
	char									ReadChar();
	CBuffer*								ReadZString();
	int										ReadInt32();
	unsigned int							ReadUInt32();
	short									ReadInt16();
	unsigned short							ReadUInt16();
	unsigned char							ReadByte();
	double									ReadDouble();
	
	//funkce pro vytvoreni instance funkce :)
	CFunctionInstance*						MakeInstance(FUNCTION_HEADER* function);
public:
	CScript(void);
	~CScript(void);
	//funkce pro nacteni skriptu
	HRESULT									LoadScript(const char* file);			
	//funkce pro vykonani iMaxInstructions instrukci z kazde bezici funkce
    void									HandleScripts(int iMaxInstructions = MAX_INSTRUCTIONS,bool* isnext = NULL);
	//funkce spusti funkci "main", pokud ve skriptu je
	HRESULT									StartMain();							
	//zastavi vsechny bezici funkce tim ze vyprazdni seznam bezicich funkci
	void									Stop();
	//spusti funkci s urcitym jmenem
	HRESULT									RunFunction(char* function);			//spusti zadanou funkci
	//Funkce pro ziskani ruznych informaci o skriptu
	unsigned int							GetCodeSegmentSize()					{return m_ScriptDependencies.m_CodeSegmentSize;}
	unsigned char*							GetCodeSegment()						{return m_ScriptDependencies.m_CodeSegment;}
	unsigned int							GetNumConstants()						{return m_ScriptDependencies.m_NumConstants;}
	CStack<StackItem>*						GetConstantTable()						{return &(m_ScriptDependencies.m_ConstantTable);}
	CList<FUNCTION_HEADER*>*				GetFunctionsList()						{return &m_FunctionTemplates;}
	CFunctionInstance*						GetCurrFunction()						{return m_CurrFunction;}

	HRESULT									AddRef();
	HRESULT									Release();
};
